//默认字体设置
function SetDefaultFont() {
    if (window.navigator.platform.toLowerCase().indexOf('win') > -1) {
        //黑体
        $("body").css('font-family', 'SimHei')
    } else {
        //mac平方字体
        $("body").css('font-family', 'PingFangSC-Regular, sans-serif')
    }
}

//打开默认浏览器
function openURLInDefaultBrowser(url) {
    try {
        window.cep.util.openURLInDefaultBrowser(url);
    } catch (e) {

    }
}

//文档启动注册事件
$(document).ready(function () {
    $("#pause").click(function () {
        //保存数据
        //$("#prog").css("width", "10%").text("等待启动");

        var value = 100;
        $("#prog").css("width", value + "%").text(value + "%");
    });

    $("#ExtendClose").click(function () {
        //保存数据
        window.__adobe_cep__.closeExtension();//关闭扩展
    });

    SetDefaultFont();
});

//所有元素input禁止拖拽
function AllInputBanDrag() {
    $("input").each(function (i) {
        $(this)[0].ondragstart = function () {
            return false;
        };
    })
}

//页面所有内容加载完成执行
window.onload = function () {
    //屏蔽右击
    document.oncontextmenu = function () {
        return false;
    }

    //禁止拖拽
    AllInputBanDrag();

    //重新确定窗口大小
    //ResizeWindow();

    //开始更新操作
    try {
        setTimeout(PluginsUpdate, 0);
    } catch (e) {

    }
}

//加载文件
function loadJSX(fileName) {
    try {
        var csInter = new CSInterface();
        var extensionRoot = csInter.getSystemPath(SystemPath.EXTENSION) + "/jsx/";// 这里是指插件目录下的 jsx 文件夹，可自行设为任意目录
        var script = '$.evalFile("' + extensionRoot + fileName + '")';
        csInter.evalScript(script);
    } catch (e) {

    }
}

function ResizeWindow() {
    try {
        //var w=$("#main_ui").width()-40;
        var w = $("#main_ui").width();
        var h = $("#main_ui").height();
        window.__adobe_cep__.resizeContent(w, h);
    } catch (e) {

    }
}

//右键菜单响应
function flyoutMenuClickedHandler(item) {
    switch (item["data"]["menuId"]) {
        case "ZhiLiaoZhuYe":
            window.cep.util.openURLInDefaultBrowser('http://www.zhiliaos.com');//知了网址
            break;
        case "Refresh":
            window.location.reload();
            break;
    }
}

//菜单加载
function AddMenu() {
    try {
        var flyoutXML = "<Menu><MenuItem Id=\"ZhiLiaoZhuYe\" Label=\"知了主页\" Enabled=\"true\" Checked=\"false\"/><MenuItem Id=\"Refresh\" Label=\"刷新\" Enabled=\"true\" Checked=\"false\"/></Menu>";
        var csInter = new CSInterface();
        csInter.setPanelFlyoutMenu(flyoutXML);
        csInter.addEventListener("com.adobe.csxs.events.flyoutMenuClicked", flyoutMenuClickedHandler);
    } catch (e) {
        console.log("AddMenu 错误:" + e.toString());
    }
}

AddMenu();

//重载页面
function PageReload() {
    location.reload();
}

//跳转
// window.ServerIP = "http://192.168.87.132:8000/";
window.ServerIP = "http://www.zlplugin.com:8000/";

function GotoByPluginID() {
    try {
        var extID = window.__adobe_cep__.getExtensionId();

        //构建表单数据
        var formData = new FormData();
        formData.append("Custom", "A8D2E850-A943-4124-B9E2-7A12DA522F9C");
        formData.append("PluginsID", extID);

        //提交数据到服务器
        $.ajax({
            contentType: "multipart/form-data",
            url: window.ServerIP + "FrontPluginManager/GetExtendPluginWebsiteByID",
            type: "POST",
            data: formData,
            dataType: "text",
            processData: false, // 告诉jQuery不要去处理发送的数据
            contentType: false, // 告诉jQuery不要去设置Content-Type请求头
            success: function (result) {
                //console.log(result);
                var rltObj = JSON.parse(result);
                if (rltObj.status == 'success') {
                    window.location = rltObj.website;
                }
            },
            error: function (jqXHR, thrownError) {
                console.log("thrownError:" + thrownError);
            }
        });
    } catch
        (e) {

    }
}

GotoByPluginID();
